﻿using System;
using System.Runtime.InteropServices;
using System.Windows.Forms;

namespace PWS.API.AVI
{
    public partial class FormMain : Form
    {
        public const int OF_Create = 0x1000;
        public const int OF_Read = 0x0;
        public const int OF_ReadWrite = 0x2;
        public const int OF_Share_Deny_None = 0x40;
        public const int OF_Share_Deny_Read = 0x30;
        public const int OF_Share_Deny_Write = 0x20;
        public const int OF_Share_Exetusive = 0x10;
        public const int OF_Write = 0x1;

        private struct AVIFileInfo
        {
            public int dwCaps;
            public int dwEditCount;
            public int dwFlags;
            public int dwHeight;
            public int dwLength;
            public int dwMaxBytesPerSec;
            public int dwRate;
            public int dwScale;
            public int dwStreams;
            public int dwSuggestedBufferSize;
            public int dwWidth;
            [MarshalAs(UnmanagedType.ByValArray, SizeConst = 64)]
            public char[] szFileType;
        }

        public FormMain()
        {
            InitializeComponent();
        }

        [DllImport("avifil32.dll", ExactSpelling = true, CharSet = CharSet.Ansi, SetLastError = true)]
        private static extern void AVIFileExit();

        [DllImport("avifil32.dll", EntryPoint = "AVIFileInfoA", ExactSpelling = true, CharSet = CharSet.Ansi, SetLastError = true)]
        private static extern int AVIFileInfo_Renamed(IntPtr pfile, ref AVIFileInfo pfi, int lSize);

        [DllImport("avifil32.dll", ExactSpelling = true, CharSet = CharSet.Ansi, SetLastError = true)]
        private static extern void AVIFileInit();

        [DllImport("avifil32.dll", EntryPoint = "AVIFileOpenA", ExactSpelling = true, CharSet = CharSet.Ansi, SetLastError = true)]
        private static extern int AVIFileOpen(ref IntPtr ppfile, string szFile, int mode, int pclsidHandler);

        [DllImport("avifil32.dll", ExactSpelling = true, CharSet = CharSet.Ansi, SetLastError = true)]
        private static extern void AVIFileRelease(IntPtr pfile);

        private void buttonOpen_Click(object sender, EventArgs e)
        {
            IntPtr hFile = IntPtr.Zero;
            AVIFileInfo info = new AVIFileInfo();

            AVIFileInit();
            if (AVIFileOpen(ref hFile, @"c:\Film\01.avi", OF_Share_Deny_Write, 0) == 0)
            {
                if (AVIFileInfo_Renamed(hFile, ref info, Marshal.SizeOf(info)) == 0)
                {
                    this.Text = @"AVI dimensions: " + info.dwWidth + @"x" + info.dwHeight;
                }
                else
                {
                    this.Text = @"Error";
                }
                AVIFileRelease(hFile);
            }
            else
            {
                this.Text = @"Error";
            }
            AVIFileExit();
        }
    }
}